/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWDesignerDocumentHelper;
import filenet.vw.apps.designer.VWPreferencesDialog;
import filenet.vw.apps.designer.VWSolutionHelper;
import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.canvas.IVWDesignerCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.VWProcessCanvasPanel;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;

public class VWDesignerCore
extends VWBaseCore
implements ItemListener,
ActionListener,
IVWCoordinationEventListener,
IVWToolbarActionListener {
    private VWDesignerCoreData m_designerCoreData = null;
    private IVWDesignerCanvasPanel m_activeCanvasPanel = null;
    private boolean m_bAppIsExiting = false;
    private JToolBar m_mainToolBar = null;
    private AbstractButton m_newButton = null;
    private AbstractButton m_openButton = null;
    private AbstractButton m_saveButton = null;
    private AbstractButton m_fileNETOpenButton = null;
    private AbstractButton m_fileNETAddButton = null;
    private AbstractButton m_fileNETCheckinButton = null;
    private AbstractButton m_fileNETCancelCheckoutButton = null;
    private AbstractButton m_fileNETSaveButton = null;
    private Component m_validationToolbarSeparator = null;
    private AbstractButton m_validateProcessCollectionButton = null;
    private AbstractButton m_launchMainProcessButton = null;
    private JLabel m_modeLabel = null;
    private JMenuBar m_menuBar = null;
    private JMenu m_fileMenu = null;
    private JMenuItem m_newPackageItem = null;
    private JMenuItem m_openItem = null;
    private JMenuItem m_closeItem = null;
    private JMenuItem m_saveItem = null;
    private JMenuItem m_saveAsItem = null;
    private JMenu m_solutionMenu = null;
    private JMenuItem m_solutionEditItem = null;
    private JMenuItem m_solutionSelectCaseItem = null;
    private JMenuItem m_solutionSaveItem = null;
    private JMenuItem m_solutionSaveAndCloseItem = null;
    private JMenuItem m_solutionCloseItem = null;
    private JMenu m_fileNetMenu = null;
    private JMenuItem m_fileNetOpenItem = null;
    private JMenuItem m_fileNetAddItem = null;
    private JMenuItem m_fileNetCheckinItem = null;
    private JMenuItem m_fileNetCancelCheckoutItem = null;
    private JMenuItem m_fileNetSaveItem = null;
    private JMenu m_insertMenu = null;
    private JMenuItem m_newProcessItem = null;
    private JMenuItem m_addLocalProcessItem = null;
    private JMenuItem m_addRepositoryProcessItem = null;
    private JMenuItem m_importVisioFileItem = null;
    private JSeparator m_scenarioSeparator = null;
    private JMenuItem m_newScenarioItem = null;
    private JMenuItem m_addLocalScenarioItem = null;
    private JMenuItem m_addRepositoryScenarioItem = null;
    private JMenuItem m_exportToFlattenedXPDLItem = null;
    private JSeparator m_fileValidateMenuSeparator = null;
    private JMenuItem m_validatePackageItem = null;
    private JMenuItem m_transferPackageItem = null;
    private JMenuItem m_launchMainProcessItem = null;
    private JMenuItem m_packagePropertiesItem = null;
    private JMenuItem m_exitItem = null;
    private JMenu m_viewMenu = null;
    private JMenu m_scenarioCollectionMenuItem = null;
    private JMenuItem m_configurationItem = null;
    private JMenuItem m_rolesItem = null;
    private JMenuItem m_inbasketsItem = null;
    private JMenu m_actionMenu = null;
    private JMenu m_toolsMenu = null;
    private JMenuItem m_openPWMItem = null;
    private JMenuItem m_openProcessAdministratorItem = null;
    private JMenuItem m_openSimulationConsoleItem = null;
    private JMenu m_ModeMenu = null;
    private ButtonGroup m_modeButtonGroup = null;
    private JMenuItem m_diagramModeItem = null;
    private JMenuItem m_designModeItem = null;
    private JMenuItem m_preferencesItem = null;
    private JMenu m_helpMenu = null;
    private JMenuItem m_contentsItem = null;
    private JMenuItem m_tutorialsItem = null;
    private JMenuItem m_aboutItem = null;
    private JPanel m_statusBar = null;
    private JTextField m_fileNameTextField = null;
    private JTextField m_msgTextField = null;
    private JCheckBox m_stepNamesCheckBox = null;
    private JCheckBox m_routeNamesCheckBox = null;
    private JCheckBox m_milestoneAttrsCheckBox = null;
    private JCheckBox m_conditionAttrsCheckBox = null;
    private JCheckBox m_collectorAttrsCheckBox = null;
    private JCheckBox m_textAnnotationsCheckBox = null;

    public void init(VWSessionInfo sessionInfo, int nApplicationMode) {
        VWMapAttribs mapAttribs;
        this.m_designerCoreData = new VWDesignerCoreData(sessionInfo);
        VWDefaultSessionProxy.setSession(sessionInfo.getSession());
        RepaintManager repaintManager = RepaintManager.currentManager(sessionInfo.getParentContainer());
        if (repaintManager != null && !repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        try {
            sessionInfo.getSession().fetchQueueNames(1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            this.performExitItemAction(true);
            return;
        }
        super.init(sessionInfo);
        this.initApplicationPane();
        switch (nApplicationMode) {
            case 1: {
                this.m_designModeItem.setSelected(true);
                break;
            }
            case 0: {
                this.m_ModeMenu.setVisible(false);
                this.m_diagramModeItem.setSelected(true);
                this.performModeSwitchAction();
            }
        }
        this.m_designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
        String library = sessionInfo.getProperty("library");
        String docId = sessionInfo.getProperty("docId");
        String version = sessionInfo.getProperty("version");
        String sdfVsId = sessionInfo.getProperty("solutionVsId");
        String caseTypeSymbolicName = sessionInfo.getProperty("caseTypeSymbolicName");
        String workflowName = sessionInfo.getProperty("workflowName");
        if (library != null && library.length() > 0) {
            if (sdfVsId != null && sdfVsId.length() > 0) {
                this.m_designerCoreData.performEditSolutionAction(library, sdfVsId, caseTypeSymbolicName, workflowName);
            } else {
                this.m_designerCoreData.getDesignerDocumentHelper().getAndOpenFileNetDocument(library, docId, version);
            }
        } else if (docId != null && docId.length() > 0) {
            this.m_designerCoreData.getDesignerDocumentHelper().openLocalFile(docId);
        }
        if (this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition() == null) {
            this.m_designerCoreData.getDesignerDocumentHelper().performNewItemAction();
        }
        if ((mapAttribs = this.m_designerCoreData.getMapAttributes()) != null) {
            mapAttribs.setShouldDisplayP8Options(sessionInfo.getDisplayP8BPMFunctionality());
        }
        super.performInitialRefresh();
    }

    public boolean destroy() {
        boolean bOkToDestroy = this.performExitItemAction(false);
        if (bOkToDestroy) {
            this.releaseReferences();
        }
        return bOkToDestroy;
    }

    public void itemStateChanged(ItemEvent event) {
        boolean bShow;
        Object src = event.getSource();
        boolean bl = bShow = event.getStateChange() == 1;
        if (src == this.m_stepNamesCheckBox) {
            this.performShowHideStepNames(bShow);
        } else if (src == this.m_routeNamesCheckBox) {
            this.performShowHideRouteNames(bShow);
        } else if (src == this.m_milestoneAttrsCheckBox) {
            this.performShowHideMilestoneAttrs(bShow);
        } else if (src == this.m_conditionAttrsCheckBox) {
            this.performShowHideConditionAttrs(bShow);
        } else if (src == this.m_collectorAttrsCheckBox) {
            this.performShowHideCollectorAttrs(bShow);
        } else if (src == this.m_textAnnotationsCheckBox) {
            this.performShowHideTextAnnotations(bShow);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_newPackageItem || object == this.m_newButton || object == this.m_closeItem) {
            if (this.m_designerCoreData.getDesignerDocumentHelper().saveExistingDefinition(null)) {
                this.m_designerCoreData.getDesignerDocumentHelper().performNewItemAction();
            }
        } else if (object == this.m_openItem || object == this.m_openButton) {
            if (this.m_designerCoreData.getDesignerDocumentHelper().saveExistingDefinition(null)) {
                this.m_designerCoreData.getDesignerDocumentHelper().performOpenItemAction();
            }
        } else if (object == this.m_saveItem || object == this.m_saveButton) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(false)) {
                return;
            }
            if (this.m_designerCoreData.getDesignerDocumentHelper().checkInOrCancelCheckOutFileNetDocument(VWResource.s_continueWithSave)) {
                this.m_designerCoreData.getDesignerDocumentHelper().performSaveItemAction();
            }
        } else if (object == this.m_saveAsItem) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(false)) {
                return;
            }
            if (this.m_designerCoreData.getDesignerDocumentHelper().checkInOrCancelCheckOutFileNetDocument(VWResource.s_continueWithSave)) {
                this.m_designerCoreData.getDesignerDocumentHelper().performSaveAsItemAction();
            }
        } else if (object == this.m_solutionEditItem) {
            if (this.m_designerCoreData.getDesignerDocumentHelper().saveExistingDefinition(null)) {
                this.m_designerCoreData.performEditSolutionAction(null, null, null, null);
            }
        } else if (object == this.m_solutionSelectCaseItem) {
            this.m_designerCoreData.getSolutionHelper().performSelectCaseTypeAction(true, null);
        } else if (object == this.m_solutionSaveItem) {
            this.m_designerCoreData.getSolutionHelper().performSaveAction();
        } else if (object == this.m_solutionSaveAndCloseItem) {
            boolean bExit = this.m_designerCoreData.getSolutionHelper().isSolutionOpenedFromCaseBuilder();
            if (this.m_designerCoreData.getSolutionHelper().performSaveAndCloseAction() && bExit) {
                this.performExitItemAction(true);
            }
        } else if (object == this.m_solutionCloseItem) {
            boolean bExit = this.m_designerCoreData.getSolutionHelper().isSolutionOpenedFromCaseBuilder();
            if (this.m_designerCoreData.getSolutionHelper().performCloseAction(true) && bExit) {
                this.performExitItemAction(true);
            }
        } else if (object == this.m_fileNetOpenItem || object == this.m_fileNETOpenButton) {
            if (this.m_designerCoreData.getDesignerDocumentHelper().saveExistingDefinition(null)) {
                this.m_designerCoreData.getDesignerDocumentHelper().performFileNetOpenItemAction();
            }
        } else if (object == this.m_fileNetAddItem || object == this.m_fileNETAddButton) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(false)) {
                return;
            }
            if (this.m_designerCoreData.getDesignerDocumentHelper().checkInOrCancelCheckOutFileNetDocument(VWResource.s_continueWithAddNew)) {
                this.m_designerCoreData.getDesignerDocumentHelper().performFileNetAddItemAction();
            }
        } else if (object == this.m_fileNetCheckinItem || object == this.m_fileNETCheckinButton) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(false)) {
                return;
            }
            this.m_designerCoreData.getDesignerDocumentHelper().performFileNetCheckinItemAction();
        } else if (object == this.m_fileNetCancelCheckoutItem || object == this.m_fileNETCancelCheckoutButton) {
            this.m_designerCoreData.getDesignerDocumentHelper().performFileNetCancelCheckoutItemAction();
        } else if (object == this.m_fileNetSaveItem || object == this.m_fileNETSaveButton) {
            this.m_designerCoreData.getDesignerDocumentHelper().performFileNetSaveItemAction();
        } else if (event.getSource().equals(this.m_newProcessItem)) {
            this.m_designerCoreData.getProcessMenuHelper().addNewProcess();
        } else if (event.getSource().equals(this.m_addLocalProcessItem)) {
            this.m_designerCoreData.getProcessMenuHelper().addLocalProcess();
        } else if (event.getSource().equals(this.m_addRepositoryProcessItem)) {
            this.m_designerCoreData.getProcessMenuHelper().addRepositoryProcess();
        } else if (object == this.m_importVisioFileItem) {
            this.m_designerCoreData.getProcessMenuHelper().performImportVisioFileAction();
        } else if (object == this.m_exportToFlattenedXPDLItem) {
            this.m_designerCoreData.getDesignerDocumentHelper().performExportToFlattenedXPDLAction();
        } else if (event.getSource().equals(this.m_newScenarioItem)) {
            this.m_designerCoreData.getScenarioMenuHelper().addNewScenario();
        } else if (event.getSource().equals(this.m_addLocalScenarioItem)) {
            this.m_designerCoreData.getScenarioMenuHelper().addLocalScenario();
        } else if (event.getSource().equals(this.m_addRepositoryScenarioItem)) {
            this.m_designerCoreData.getScenarioMenuHelper().addRepositoryScenario();
        } else if (object == this.m_validatePackageItem || object == this.m_validateProcessCollectionButton) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(false)) {
                return;
            }
            this.m_designerCoreData.getProcessMenuHelper().validateProcessCollection(this, true);
        } else if (object == this.m_transferPackageItem) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(true)) {
                return;
            }
            this.m_designerCoreData.getProcessMenuHelper().transferProcessCollection(this, true);
        } else if (object == this.m_launchMainProcessItem || object == this.m_launchMainProcessButton) {
            if (!this.m_designerCoreData.getTabbedCanvasPanel().saveConfigurationChanges(true)) {
                return;
            }
            this.m_designerCoreData.getProcessMenuHelper().launchMainProcess(this);
        } else if (object == this.m_packagePropertiesItem) {
            this.m_designerCoreData.displayPackageProperties();
        } else if (object == this.m_exitItem) {
            this.performExitItemAction(true);
        } else if (object == this.m_configurationItem) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 735, null);
        } else if (object == this.m_rolesItem) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 736, null);
        } else if (object == this.m_inbasketsItem) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 737, null);
        } else if (object == this.m_openPWMItem) {
            this.performOpenPWMItemAction();
        } else if (object == this.m_openProcessAdministratorItem) {
            this.performOpenProcessAdministratorItemAction();
        } else if (event.getSource().equals(this.m_openSimulationConsoleItem)) {
            this.performOpenSimulationConsoleItemAction();
        } else if (object == this.m_diagramModeItem) {
            this.performModeSwitchAction();
        } else if (object == this.m_designModeItem) {
            this.performModeSwitchAction();
        } else if (object == this.m_preferencesItem) {
            this.performPreferencesItemAction(0);
        } else if (object == this.m_contentsItem) {
            VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh500.htm");
        } else if (object == this.m_tutorialsItem) {
            VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh197.htm");
        } else if (object == this.m_aboutItem) {
            this.performAboutItemAction();
        } else {
            boolean bIsDirty = this.m_designerCoreData.getProcessMenuHelper().getIsCollectionDirty();
            super.actionPerformed(event);
            if (!bIsDirty) {
                this.m_designerCoreData.getProcessMenuHelper().clearCollectionDirtyFlag();
            }
        }
    }

    public void windowClosing(WindowEvent event) {
        if (event == null) {
            return;
        }
        this.releaseReferences();
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        if (event.getSource() == this) {
            return;
        }
        switch (event.getID()) {
            case 701: 
            case 702: {
                this.updateFileMenu();
                break;
            }
            case 700: {
                this.m_activeCanvasPanel = null;
                this.updateFileMenu();
                break;
            }
            case 720: {
                this.m_activeCanvasPanel = (IVWDesignerCanvasPanel)event.getEventParam();
                break;
            }
            case 721: {
                this.m_activeCanvasPanel = null;
                break;
            }
            case 740: {
                this.performDisplayOptionsChangedAction();
                break;
            }
            case 738: {
                int nType = -1;
                if (event.getEventParam() != null) {
                    nType = (Integer)event.getEventParam();
                }
                this.performPreferencesItemAction(nType);
                break;
            }
            case 752: {
                if (this.m_msgTextField == null) break;
                this.m_msgTextField.setText(this.m_designerCoreData.getStepPaletteDocumentHelper().getSavedFileName());
            }
        }
        this.m_actionMenu.removeAll();
        if (this.m_activeCanvasPanel != null) {
            this.m_activeCanvasPanel.initializeActionMenu(this.m_actionMenu);
        }
        this.m_actionMenu.setEnabled(this.m_actionMenu.getMenuComponentCount() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 650: {
                this.m_designerCoreData.getProcessMenuHelper().validateProcessCollection(this, true);
                break;
            }
            case 651: {
                if (this.m_activeCanvasPanel == null || !(this.m_activeCanvasPanel instanceof VWProcessCanvasPanel)) break;
                processCanvasPanel = (VWProcessCanvasPanel)this.m_activeCanvasPanel;
                try {
                    try {
                        processCanvasPanel.displayWaitCursor();
                        if (processCanvasPanel == null) ** GOTO lbl23
                        authPropertyData = processCanvasPanel.getAuthPropertyData();
                        this.m_designerCoreData.getProcessMenuHelper().validateProcess(authPropertyData, true);
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        var5_6 = null;
                        processCanvasPanel.restoreDefaultCursor();
                        break;
                    }
lbl23:
                    // 2 sources

                    var5_5 = null;
                    processCanvasPanel.restoreDefaultCursor();
                    break;
                }
                catch (Throwable var4_8) {
                    var5_7 = null;
                    processCanvasPanel.restoreDefaultCursor();
                    throw var4_8;
                }
            }
        }
    }

    private void initApplicationPane() {
        try {
            Container parentContainer = this.m_designerCoreData.getSessionInfo().getParentContainer();
            parentContainer.setLayout(new BorderLayout());
            this.initMenuBar();
            this.initToolBar();
            this.initStatusBar();
            parentContainer.add((Component)this.m_designerCoreData.getMainPanel(this), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private void initMenuBar() {
        this.m_menuBar = new JMenuBar();
        if (this.m_menuBar != null && this.m_menuBar.getMenuCount() > 0) {
            this.m_menuBar.removeAll();
        }
        this.initFileMenu();
        if (this.m_fileMenu != null && this.m_fileMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_fileMenu);
        }
        this.initEditMenu();
        this.initViewMenu();
        if (this.m_viewMenu != null && this.m_viewMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_viewMenu);
        }
        this.initActionMenu();
        if (this.m_actionMenu != null) {
            this.m_menuBar.add(this.m_actionMenu);
        }
        this.initToolsMenu();
        if (this.m_toolsMenu != null) {
            this.m_menuBar.add(this.m_toolsMenu);
        }
        this.initSettingsMenu();
        if (this.m_settingsMenu != null) {
            this.m_menuBar.add(this.m_settingsMenu);
        }
        this.initHelpMenu();
        if (this.m_helpMenu != null && this.m_helpMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_helpMenu);
        }
        this.m_designerCoreData.getSessionInfo().getParentRootPane().setJMenuBar(this.m_menuBar);
    }

    private void initFileMenu() {
        this.m_fileMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuFile_withHK);
        if (this.m_fileMenu != null) {
            int nMenuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            this.m_newPackageItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuNew_withHK);
            if (this.m_newPackageItem != null) {
                this.m_newPackageItem.setIcon(VWImageLoader.createImageIcon("newPackage16.gif"));
                this.m_newPackageItem.setAccelerator(KeyStroke.getKeyStroke(78, nMenuShortcutKeyMask));
                this.m_newPackageItem.addActionListener(this);
                this.m_fileMenu.add(this.m_newPackageItem);
            }
            this.m_openItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuOpen_withHK);
            if (this.m_openItem != null) {
                this.m_openItem.setIcon(VWImageLoader.createImageIcon("openPackage16.gif"));
                this.m_openItem.setAccelerator(KeyStroke.getKeyStroke(79, nMenuShortcutKeyMask));
                this.m_openItem.addActionListener(this);
                this.m_fileMenu.add(this.m_openItem);
            }
            this.m_closeItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuClose_withHK);
            if (this.m_closeItem != null) {
                this.m_closeItem.setIcon(VWImageLoader.createImageIcon("blank.gif"));
                this.m_closeItem.addActionListener(this);
                this.m_fileMenu.add(this.m_closeItem);
            }
            this.m_fileMenu.addSeparator();
            this.m_saveItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSave_withHK);
            if (this.m_saveItem != null) {
                this.m_saveItem.setIcon(VWImageLoader.createImageIcon("savePackage16.gif"));
                this.m_saveItem.setAccelerator(KeyStroke.getKeyStroke(83, nMenuShortcutKeyMask));
                this.m_saveItem.addActionListener(this);
                this.m_fileMenu.add(this.m_saveItem);
            }
            this.m_saveAsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSaveAs_withHK);
            if (this.m_saveAsItem != null) {
                this.m_saveAsItem.setIcon(VWImageLoader.createImageIcon("blank.gif"));
                this.m_saveAsItem.addActionListener(this);
                this.m_fileMenu.add(this.m_saveAsItem);
            }
            this.m_fileMenu.addSeparator();
            if (this.m_designerCoreData.getSessionInfo().getCanSaveToDMS()) {
                if (this.m_designerCoreData.getSessionInfo().getDisplayP8BPMFunctionality()) {
                    this.m_solutionMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuSolution_withHK);
                    if (this.m_solutionMenu != null) {
                        this.m_fileMenu.add(this.m_solutionMenu);
                        this.m_solutionEditItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSolutionEdit_withHK);
                        if (this.m_solutionEditItem != null) {
                            this.m_solutionEditItem.addActionListener(this);
                            this.m_solutionMenu.add(this.m_solutionEditItem);
                        }
                        this.m_solutionSelectCaseItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSolutionSelectCase_withHK);
                        if (this.m_solutionSelectCaseItem != null) {
                            this.m_solutionSelectCaseItem.addActionListener(this);
                            this.m_solutionSelectCaseItem.setEnabled(false);
                            this.m_solutionMenu.add(this.m_solutionSelectCaseItem);
                        }
                        this.m_solutionSaveItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSolutionSave_withHK);
                        if (this.m_solutionSaveItem != null) {
                            this.m_solutionSaveItem.addActionListener(this);
                            this.m_solutionSaveItem.setEnabled(false);
                            this.m_solutionMenu.add(this.m_solutionSaveItem);
                        }
                        this.m_solutionSaveAndCloseItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSolutionSaveAndClose_withHK);
                        if (this.m_solutionSaveAndCloseItem != null) {
                            this.m_solutionSaveAndCloseItem.addActionListener(this);
                            this.m_solutionSaveAndCloseItem.setEnabled(false);
                            this.m_solutionMenu.add(this.m_solutionSaveAndCloseItem);
                        }
                        this.m_solutionCloseItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSolutionClose_withHK);
                        if (this.m_solutionCloseItem != null) {
                            this.m_solutionCloseItem.addActionListener(this);
                            this.m_solutionCloseItem.setEnabled(false);
                            this.m_solutionMenu.add(this.m_solutionCloseItem);
                        }
                        this.m_fileMenu.addSeparator();
                    }
                }
                this.m_fileNetMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuFileNet_withHK);
                if (this.m_fileNetMenu != null) {
                    this.m_fileMenu.add(this.m_fileNetMenu);
                    this.m_fileNetOpenItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnOpen_withHK);
                    if (this.m_fileNetOpenItem != null) {
                        this.m_fileNetOpenItem.setIcon(VWImageLoader.createImageIcon("fnOpen16.gif"));
                        this.m_fileNetOpenItem.addActionListener(this);
                        this.m_fileNetMenu.add(this.m_fileNetOpenItem);
                    }
                    this.m_fileNetAddItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnAdd_withHK);
                    if (this.m_fileNetAddItem != null) {
                        this.m_fileNetAddItem.setIcon(VWImageLoader.createImageIcon("fnAddNew16.gif"));
                        this.m_fileNetAddItem.addActionListener(this);
                        this.m_fileNetMenu.add(this.m_fileNetAddItem);
                    }
                    this.m_fileNetCheckinItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnCheckin_withHK);
                    if (this.m_fileNetCheckinItem != null) {
                        this.m_fileNetCheckinItem.setIcon(VWImageLoader.createImageIcon("fnCheckin16.gif"));
                        this.m_fileNetCheckinItem.addActionListener(this);
                        this.m_fileNetCheckinItem.setEnabled(false);
                        this.m_fileNetMenu.add(this.m_fileNetCheckinItem);
                    }
                    this.m_fileNetCancelCheckoutItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnCancelCheckout_withHK);
                    if (this.m_fileNetCancelCheckoutItem != null) {
                        this.m_fileNetCancelCheckoutItem.setIcon(VWImageLoader.createImageIcon("fnCancelCheckout16.gif"));
                        this.m_fileNetCancelCheckoutItem.addActionListener(this);
                        this.m_fileNetCancelCheckoutItem.setEnabled(false);
                        this.m_fileNetMenu.add(this.m_fileNetCancelCheckoutItem);
                    }
                    this.m_fileNetSaveItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnSave_withHK);
                    if (this.m_fileNetSaveItem != null) {
                        this.m_fileNetSaveItem.setIcon(VWImageLoader.createImageIcon("fnSave16.gif"));
                        this.m_fileNetSaveItem.addActionListener(this);
                        this.m_fileNetSaveItem.setEnabled(false);
                        this.m_fileNetMenu.add(this.m_fileNetSaveItem);
                    }
                }
            }
            this.m_insertMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuInsert_withHK);
            if (this.m_insertMenu != null) {
                this.m_fileMenu.add(this.m_insertMenu);
                this.m_newProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuNewWorkflow_withHK);
                if (this.m_newProcessItem != null) {
                    this.m_newProcessItem.addActionListener(this);
                    this.m_insertMenu.add(this.m_newProcessItem);
                }
                this.m_addLocalProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuLocalWorkflow_withHK);
                if (this.m_addLocalProcessItem != null) {
                    this.m_addLocalProcessItem.addActionListener(this);
                    this.m_insertMenu.add(this.m_addLocalProcessItem);
                }
                this.m_addRepositoryProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuWorkflowFromRepository_withHK);
                if (this.m_addRepositoryProcessItem != null) {
                    this.m_addRepositoryProcessItem.addActionListener(this);
                    this.m_insertMenu.add(this.m_addRepositoryProcessItem);
                }
                if (this.m_designerCoreData.getSessionInfo().getDisplayFullBPMFunctionality() && this.m_designerCoreData.getSessionInfo().getDisplayPDExFunctionality()) {
                    this.m_importVisioFileItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuImportedVisioFile_withHK);
                    if (this.m_importVisioFileItem != null) {
                        this.m_importVisioFileItem.addActionListener(this);
                        this.m_insertMenu.add(this.m_importVisioFileItem);
                    }
                }
                if (this.m_designerCoreData.getSessionInfo().getDisplaySimulationDesignerFunctionality()) {
                    this.m_scenarioSeparator = new JSeparator();
                    this.m_insertMenu.add(this.m_scenarioSeparator);
                    this.m_newScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuNewScenario_withHK);
                    if (this.m_newScenarioItem != null) {
                        this.m_newScenarioItem.addActionListener(this);
                        this.m_insertMenu.add(this.m_newScenarioItem);
                    }
                    this.m_addLocalScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuLocalScenario_withHK);
                    if (this.m_addLocalScenarioItem != null) {
                        this.m_addLocalScenarioItem.addActionListener(this);
                        this.m_insertMenu.add(this.m_addLocalScenarioItem);
                    }
                    this.m_addRepositoryScenarioItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuScenarioFromRepository_withHK);
                    if (this.m_addRepositoryScenarioItem != null) {
                        this.m_addRepositoryScenarioItem.addActionListener(this);
                        this.m_insertMenu.add(this.m_addRepositoryScenarioItem);
                    }
                }
            }
            if (this.m_designerCoreData.getSessionInfo().getDisplayFullBPMFunctionality()) {
                this.m_exportToFlattenedXPDLItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuExportToFlattenedXPDL_withHK);
                if (this.m_exportToFlattenedXPDLItem != null) {
                    this.m_exportToFlattenedXPDLItem.setIcon(VWImageLoader.createImageIcon("blank.gif"));
                    this.m_exportToFlattenedXPDLItem.addActionListener(this);
                    this.m_fileMenu.add(this.m_exportToFlattenedXPDLItem);
                }
            }
            this.m_fileValidateMenuSeparator = new JSeparator();
            this.m_fileMenu.add(this.m_fileValidateMenuSeparator);
            this.m_validatePackageItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuValidateWorkflowCollection_withHK);
            if (this.m_validatePackageItem != null) {
                this.m_validatePackageItem.setIcon(VWImageLoader.createImageIcon("validatePackage16.gif"));
                this.m_validatePackageItem.addActionListener(this);
                this.m_fileMenu.add(this.m_validatePackageItem);
            }
            this.m_transferPackageItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuTransferWorkflowCollection_withHK);
            if (this.m_transferPackageItem != null) {
                this.m_transferPackageItem.setIcon(VWImageLoader.createImageIcon("blank.gif"));
                this.m_transferPackageItem.addActionListener(this);
                this.m_fileMenu.add(this.m_transferPackageItem);
            }
            this.m_launchMainProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuLaunchMainWorkflow_withHK);
            if (this.m_launchMainProcessItem != null) {
                this.m_launchMainProcessItem.setIcon(VWImageLoader.createImageIcon("launchMainProcess16.gif"));
                this.m_launchMainProcessItem.addActionListener(this);
                this.m_fileMenu.add(this.m_launchMainProcessItem);
            }
            this.m_fileMenu.addSeparator();
            this.m_packagePropertiesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuWorkflowCollectionProperties_withHK);
            if (this.m_packagePropertiesItem != null) {
                this.m_packagePropertiesItem.setIcon(VWImageLoader.createImageIcon("blank.gif"));
                this.m_packagePropertiesItem.addActionListener(this);
                this.m_fileMenu.add(this.m_packagePropertiesItem);
            }
            this.m_fileMenu.addSeparator();
            this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuExit_withHK);
            if (this.m_exitItem != null) {
                this.m_exitItem.setIcon(VWImageLoader.createImageIcon("blank.gif"));
                this.m_exitItem.addActionListener(this);
                this.m_fileMenu.add(this.m_exitItem);
            }
        }
    }

    private void initEditMenu() {
    }

    private void initViewMenu() {
        this.m_viewMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuView_withHK);
        if (this.m_viewMenu != null) {
            JMenu processCollectionMenuItem = this.m_designerCoreData.getProcessMenuHelper().getProcessCollectionMenu();
            if (processCollectionMenuItem != null) {
                this.m_viewMenu.add(processCollectionMenuItem);
            }
            if (this.m_designerCoreData.getSessionInfo().getDisplaySimulationDesignerFunctionality()) {
                this.m_scenarioCollectionMenuItem = this.m_designerCoreData.getScenarioMenuHelper().getScenarioCollectionMenu();
                if (this.m_scenarioCollectionMenuItem != null) {
                    this.m_viewMenu.add(this.m_scenarioCollectionMenuItem);
                }
            }
            try {
                if (this.m_designerCoreData.getSessionInfo().getDisplayConfigurationFunctionality()) {
                    this.m_configurationItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuConfiguration_withHK);
                    if (this.m_configurationItem != null) {
                        this.m_configurationItem.setIcon(VWImageLoader.createImageIcon("iso_logon_16.gif"));
                        this.m_configurationItem.addActionListener(this);
                        this.m_viewMenu.add(this.m_configurationItem);
                    }
                    this.m_rolesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuRoles_withHK);
                    if (this.m_rolesItem != null) {
                        this.m_rolesItem.setIcon(VWImageLoader.createImageIcon("roles16.gif"));
                        this.m_rolesItem.addActionListener(this);
                        this.m_viewMenu.add(this.m_rolesItem);
                    }
                    this.m_inbasketsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuInbaskets_withHK);
                    if (this.m_inbasketsItem != null) {
                        this.m_inbasketsItem.setIcon(VWImageLoader.createImageIcon("in-basket16.gif"));
                        this.m_inbasketsItem.addActionListener(this);
                        this.m_viewMenu.add(this.m_inbasketsItem);
                    }
                }
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
    }

    private void initActionMenu() {
        this.m_actionMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuAction_withHK);
    }

    private void initToolsMenu() {
        this.m_toolsMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuTools_withHK);
        if (this.m_toolsMenu != null) {
            this.m_openPWMItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuPersonalWorkManager_withHK);
            if (this.m_openPWMItem != null) {
                this.m_openPWMItem.addActionListener(this);
                this.m_toolsMenu.add(this.m_openPWMItem);
            }
            if (this.m_designerCoreData.getSessionInfo().getDisplayAdministrationFunctionality()) {
                this.m_openProcessAdministratorItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuProcessAdministrator_withHK);
                if (this.m_openProcessAdministratorItem != null) {
                    this.m_openProcessAdministratorItem.addActionListener(this);
                    this.m_toolsMenu.add(this.m_openProcessAdministratorItem);
                }
            }
            if (this.m_designerCoreData.getSessionInfo().getDisplaySimulationConsoleFunctionality()) {
                this.m_toolsMenu.add(new JSeparator());
                this.m_openSimulationConsoleItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSimulationConsole_withHK);
                if (this.m_openSimulationConsoleItem != null) {
                    this.m_openSimulationConsoleItem.addActionListener(this);
                    this.m_toolsMenu.add(this.m_openSimulationConsoleItem);
                }
            }
        }
    }

    private void initSettingsMenu() {
        this.m_settingsMenu = this.getSettingsMenu(this.m_menuBar);
        if (this.m_settingsMenu != null) {
            this.m_ModeMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuMode_withHK);
            if (this.m_ModeMenu != null) {
                this.m_ModeMenu.getAccessibleContext().setAccessibleName(VWResource.s_menuMode_withHK);
                this.m_ModeMenu.getAccessibleContext().setAccessibleDescription(VWResource.s_menuMode_withHK);
                this.m_modeButtonGroup = new ButtonGroup();
                this.m_diagramModeItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuDiagramMode_withHK);
                this.m_ModeMenu.add(this.m_diagramModeItem);
                this.m_modeButtonGroup.add(this.m_diagramModeItem);
                AccessibleContext accessible_context = this.m_diagramModeItem.getAccessibleContext();
                AccessibleRelationSet relationSet = accessible_context.getAccessibleRelationSet();
                AccessibleRelation grouped = new AccessibleRelation(AccessibleRelation.MEMBER_OF, this.m_modeButtonGroup);
                relationSet.add(grouped);
                this.m_diagramModeItem.addActionListener(this);
                this.m_diagramModeItem.getAccessibleContext().setAccessibleName(VWResource.s_menuDiagramMode_withHK);
                this.m_diagramModeItem.getAccessibleContext().setAccessibleDescription(VWResource.s_menuDiagramMode_withHK);
                this.m_diagramModeItem.getAccessibleContext().setAccessibleParent(this.m_ModeMenu);
                this.m_designModeItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuDesignMode_withHK);
                this.m_ModeMenu.add(this.m_designModeItem);
                this.m_modeButtonGroup.add(this.m_designModeItem);
                accessible_context = this.m_designModeItem.getAccessibleContext();
                relationSet = accessible_context.getAccessibleRelationSet();
                grouped = new AccessibleRelation(AccessibleRelation.MEMBER_OF, this.m_modeButtonGroup);
                relationSet.add(grouped);
                this.m_designModeItem.addActionListener(this);
                this.m_designModeItem.getAccessibleContext().setAccessibleName(VWResource.s_menuDesignMode_withHK);
                this.m_designModeItem.getAccessibleContext().setAccessibleDescription(VWResource.s_menuDesignMode_withHK);
                this.m_designModeItem.getAccessibleContext().setAccessibleParent(this.m_ModeMenu);
                this.m_settingsMenu.add(this.m_ModeMenu);
            }
            this.m_settingsMenu.addSeparator();
            this.m_preferencesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuPreferences_withHK);
            if (this.m_preferencesItem != null) {
                this.m_preferencesItem.addActionListener(this);
                this.m_settingsMenu.add(this.m_preferencesItem);
            }
        }
    }

    private void initHelpMenu() {
        this.m_helpMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuHelp_withHK);
        if (this.m_helpMenu != null) {
            this.m_contentsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuContents_withHK);
            if (this.m_contentsItem != null) {
                this.m_contentsItem.addActionListener(this);
                this.m_helpMenu.add(this.m_contentsItem);
            }
            this.m_tutorialsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuTutorials_withHK);
            if (this.m_tutorialsItem != null) {
                this.m_tutorialsItem.addActionListener(this);
                this.m_helpMenu.add(this.m_tutorialsItem);
            }
            this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuAbout_withHK);
            if (this.m_aboutItem != null) {
                this.m_aboutItem.addActionListener(this);
                this.m_helpMenu.add(this.m_aboutItem);
            }
        }
    }

    private void initToolBar() {
        this.m_mainToolBar = new JToolBar();
        this.m_mainToolBar.setFloatable(false);
        this.m_mainToolBar.setMargin(new Insets(0, 0, 0, 0));
        this.m_newButton = this.addToolBarButton(this.m_mainToolBar, "new.gif", VWResource.s_new, false, "m_newButton");
        this.m_openButton = this.addToolBarButton(this.m_mainToolBar, "open.gif", VWResource.s_open, false, "m_openButton");
        this.m_saveButton = this.addToolBarButton(this.m_mainToolBar, "save.gif", VWResource.s_save, false, "m_saveButton");
        VWImageLoader.addToolbarSeparator(this.m_mainToolBar);
        try {
            if (this.m_designerCoreData.getSessionInfo().getCanSaveToDMS()) {
                this.m_fileNETOpenButton = this.addToolBarButton(this.m_mainToolBar, "checkoutopen.gif", VWResource.s_menuFnOpen, false, "m_fileNETOpenButton");
                this.m_fileNETAddButton = this.addToolBarButton(this.m_mainToolBar, "add.gif", VWResource.s_menuFnAdd, false, "m_fileNETAddButton");
                this.m_fileNETCheckinButton = this.addToolBarButton(this.m_mainToolBar, "checkin.gif", VWResource.s_menuFnCheckin, false, "m_fileNETCheckinButton");
                this.m_fileNETCheckinButton.setEnabled(false);
                this.m_fileNETCancelCheckoutButton = this.addToolBarButton(this.m_mainToolBar, "cnclchkout.gif", VWResource.s_menuFnCancelCheckout, false, "m_fileNETCancelCheckoutButton");
                this.m_fileNETCancelCheckoutButton.setEnabled(false);
                this.m_fileNETSaveButton = this.addToolBarButton(this.m_mainToolBar, "idmsave.gif", VWResource.s_menuFnSave, false, "m_fileNETSaveButton");
                this.m_fileNETSaveButton.setEnabled(false);
                VWImageLoader.addToolbarSeparator(this.m_mainToolBar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_validationToolbarSeparator = this.m_mainToolBar.getComponent(this.m_mainToolBar.getComponentCount() - 1);
        this.m_validateProcessCollectionButton = this.addToolBarButton(this.m_mainToolBar, "validate.gif", VWResource.s_validateWorkflowCollection, false, "m_validateButton");
        this.m_launchMainProcessButton = this.addToolBarButton(this.m_mainToolBar, "launch.gif", VWResource.s_launchMainWorkflow, false, "m_launchButton");
        this.m_mainToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.m_modeLabel = new JLabel(VWResource.s_modeLabel.toString(VWResource.s_menuDesignMode));
        this.m_modeLabel.setBorder(BorderFactory.createEmptyBorder(0, 100, 0, 0));
        this.m_mainToolBar.add(this.m_modeLabel);
        this.m_designerCoreData.getSessionInfo().getParentContentPane().add((Component)this.m_mainToolBar, "First");
    }

    private AbstractButton addToolBarButton(JToolBar toolBar, String fileName, String toolTip, boolean bUseToggleButton, String name) {
        AbstractButton button = VWImageLoader.createToolBarButton(fileName, toolTip, bUseToggleButton);
        if (button != null) {
            toolBar.add(button);
            button.setRolloverEnabled(true);
            button.addActionListener(this);
            button.setName(name + "_VWDesignerCore");
        }
        return button;
    }

    private void initStatusBar() {
        try {
            this.m_statusBar = new JPanel(new GridBagLayout());
            JPanel panel = new JPanel(new BorderLayout(0, 0));
            panel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_fileNameTextField = new JTextField();
            this.m_fileNameTextField.setEditable(false);
            this.m_fileNameTextField.setFocusable(false);
            this.m_fileNameTextField.setBackground(panel.getBackground());
            this.m_fileNameTextField.setBorder(null);
            panel.add((Component)new JLabel(" "), "Before");
            panel.add((Component)this.m_fileNameTextField, "Center");
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.6;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_statusBar.add((Component)panel, gbCons);
            panel = new JPanel(new BorderLayout(0, 0));
            panel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_msgTextField = new JTextField();
            this.m_msgTextField.setEditable(false);
            this.m_msgTextField.setFocusable(false);
            this.m_msgTextField.setBackground(panel.getBackground());
            this.m_msgTextField.setBorder(null);
            panel.add((Component)new JLabel(" "), "Before");
            panel.add((Component)this.m_msgTextField, "Center");
            ++gbCons.gridx;
            gbCons.weightx = 0.4;
            this.m_statusBar.add((Component)panel, gbCons);
            panel = new JPanel(new FlowLayout(1, 0, 0));
            panel.setBorder(BorderFactory.createLoweredBevelBorder());
            panel.add(new JLabel(" "));
            this.m_stepNamesCheckBox = new JCheckBox(VWImageLoader.createImageIcon("step_hide.gif"));
            this.m_stepNamesCheckBox.setName("m_stepNamesCheckBox_VWDesignerCore");
            this.m_stepNamesCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("step_show.gif"));
            this.m_stepNamesCheckBox.setToolTipText(VWResource.s_showHideStepNamesStr);
            this.m_stepNamesCheckBox.setSelected(true);
            this.m_stepNamesCheckBox.addItemListener(this);
            panel.add(this.m_stepNamesCheckBox);
            this.m_routeNamesCheckBox = new JCheckBox(VWImageLoader.createImageIcon("route_hide.gif"));
            this.m_routeNamesCheckBox.setName("m_routeNamesCheckBox_VWDesignerCore");
            this.m_routeNamesCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("route_show.gif"));
            this.m_routeNamesCheckBox.setToolTipText(VWResource.s_showHideRouteNamesStr);
            this.m_routeNamesCheckBox.setSelected(true);
            this.m_routeNamesCheckBox.addItemListener(this);
            panel.add(this.m_routeNamesCheckBox);
            this.m_milestoneAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("milestone_hide.gif"));
            this.m_milestoneAttrsCheckBox.setName("m_milestoneAttrsCheckBox_VWDesignerCore");
            this.m_milestoneAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("milestone_show.gif"));
            this.m_milestoneAttrsCheckBox.setToolTipText(VWResource.s_showHideMilestoneAttributesStr);
            this.m_milestoneAttrsCheckBox.setSelected(true);
            this.m_milestoneAttrsCheckBox.addItemListener(this);
            panel.add(this.m_milestoneAttrsCheckBox);
            this.m_conditionAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("condition_hide.gif"));
            this.m_conditionAttrsCheckBox.setName("m_conditionAttrsCheckBox_VWDesignerCore");
            this.m_conditionAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("condition_show.gif"));
            this.m_conditionAttrsCheckBox.setToolTipText(VWResource.s_showHideConditionAttributesStr);
            this.m_conditionAttrsCheckBox.setSelected(true);
            this.m_conditionAttrsCheckBox.addItemListener(this);
            panel.add(this.m_conditionAttrsCheckBox);
            this.m_collectorAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("collector_hide.gif"));
            this.m_collectorAttrsCheckBox.setName("m_collectorAttrsCheckBox_VWDesignerCore");
            this.m_collectorAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("collector_show.gif"));
            this.m_collectorAttrsCheckBox.setToolTipText(VWResource.s_showHideCollectorAttributesStr);
            this.m_collectorAttrsCheckBox.setSelected(true);
            this.m_collectorAttrsCheckBox.addItemListener(this);
            panel.add(this.m_collectorAttrsCheckBox);
            this.m_textAnnotationsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("textAnnotation_hide.gif"));
            this.m_textAnnotationsCheckBox.setName("m_textAnnotationsCheckBox_VWDesignerCore");
            this.m_textAnnotationsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("textAnnotation_show.gif"));
            this.m_textAnnotationsCheckBox.setToolTipText(VWResource.s_showHideTextAnnotationsStr);
            this.m_textAnnotationsCheckBox.setSelected(true);
            this.m_textAnnotationsCheckBox.addItemListener(this);
            panel.add(this.m_textAnnotationsCheckBox);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_statusBar.add((Component)panel, gbCons);
            this.m_designerCoreData.getSessionInfo().getParentContentPane().add((Component)this.m_statusBar, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateFileMenu() {
        try {
            VWSolutionHelper solutionHelper = this.m_designerCoreData.getSolutionHelper();
            if (solutionHelper != null) {
                this.m_newPackageItem.setEnabled(false);
                this.m_newButton.setEnabled(false);
                this.m_openItem.setEnabled(false);
                this.m_openButton.setEnabled(false);
                this.m_closeItem.setEnabled(false);
                this.m_saveItem.setEnabled(false);
                this.m_saveButton.setEnabled(false);
                this.m_saveAsItem.setEnabled(false);
                if (this.m_solutionMenu != null) {
                    this.m_solutionEditItem.setEnabled(false);
                    this.m_solutionSelectCaseItem.setEnabled(solutionHelper.isSolutionContainsMultipleCaseTypes() && !solutionHelper.isSolutionOpenedFromCaseTaskPage());
                    this.m_solutionSaveItem.setEnabled(true);
                    this.m_solutionSaveAndCloseItem.setEnabled(true);
                    this.m_solutionCloseItem.setEnabled(true);
                }
                if (this.m_fileNetMenu != null) {
                    this.m_fileNetMenu.setEnabled(false);
                    this.m_fileNETOpenButton.setEnabled(false);
                    this.m_fileNETAddButton.setEnabled(false);
                    this.m_fileNETCheckinButton.setEnabled(false);
                    this.m_fileNETCancelCheckoutButton.setEnabled(false);
                    this.m_fileNETSaveButton.setEnabled(false);
                }
                this.m_exportToFlattenedXPDLItem.setEnabled(false);
                this.m_transferPackageItem.setEnabled(false);
                this.m_launchMainProcessItem.setEnabled(false);
                this.m_launchMainProcessButton.setEnabled(false);
                if (solutionHelper.isSolutionOpenedFromCaseTaskPage()) {
                    if (this.m_configurationItem != null) {
                        this.m_configurationItem.setEnabled(false);
                    }
                    if (this.m_rolesItem != null) {
                        this.m_rolesItem.setEnabled(false);
                    }
                    if (this.m_inbasketsItem != null) {
                        this.m_inbasketsItem.setEnabled(false);
                    }
                }
                this.m_fileNameTextField.setText(solutionHelper.getSolutionName());
            } else {
                boolean bEnable = this.m_designerCoreData.getProcessMenuHelper().getCanSaveToSameFile();
                this.m_newPackageItem.setEnabled(true);
                this.m_newButton.setEnabled(true);
                this.m_newButton.setRolloverEnabled(true);
                this.m_openItem.setEnabled(true);
                this.m_openButton.setEnabled(true);
                this.m_openButton.setRolloverEnabled(true);
                this.m_closeItem.setEnabled(true);
                this.m_saveItem.setEnabled(bEnable);
                this.m_saveButton.setEnabled(bEnable);
                this.m_saveButton.setRolloverEnabled(bEnable);
                this.m_saveAsItem.setEnabled(true);
                if (this.m_solutionMenu != null) {
                    this.m_solutionEditItem.setEnabled(true);
                    this.m_solutionSelectCaseItem.setEnabled(false);
                    this.m_solutionSaveItem.setEnabled(false);
                    this.m_solutionSaveAndCloseItem.setEnabled(false);
                    this.m_solutionCloseItem.setEnabled(false);
                }
                boolean bIsCheckedOut = false;
                VWDesignerDocumentHelper docHelper = this.m_designerCoreData.getDesignerDocumentHelper();
                if (docHelper != null) {
                    IVWIDMDocument idmDoc = docHelper.getIDMDocument();
                    if (idmDoc != null) {
                        bIsCheckedOut = idmDoc.isCheckedOut();
                        VWString checkoutMode = bIsCheckedOut ? VWResource.s_checkedOutPrompt : VWResource.s_copyPrompt;
                        String docId = this.m_designerCoreData.getSessionInfo().isWorkPlaceWebApp() ? idmDoc.getVersionNumber() : idmDoc.getIdWithVer();
                        String documentLabel = checkoutMode.toString(idmDoc.getLabel(), docId);
                        this.m_fileNameTextField.setText(documentLabel);
                    } else {
                        this.m_fileNameTextField.setText(this.m_designerCoreData.getFileContext().getSaveFileName());
                    }
                }
                if (this.m_fileNetMenu != null) {
                    this.m_fileNetMenu.setEnabled(true);
                    this.m_fileNETOpenButton.setEnabled(true);
                    this.m_fileNETOpenButton.setRolloverEnabled(true);
                    this.m_fileNETAddButton.setEnabled(true);
                    this.m_fileNETAddButton.setRolloverEnabled(true);
                    this.m_fileNetCheckinItem.setEnabled(bIsCheckedOut);
                    this.m_fileNETCheckinButton.setEnabled(bIsCheckedOut);
                    this.m_fileNETCheckinButton.setRolloverEnabled(bIsCheckedOut);
                    this.m_fileNetCancelCheckoutItem.setEnabled(bIsCheckedOut);
                    this.m_fileNETCancelCheckoutButton.setEnabled(bIsCheckedOut);
                    this.m_fileNETCancelCheckoutButton.setRolloverEnabled(bIsCheckedOut);
                    this.m_fileNetSaveItem.setEnabled(bIsCheckedOut);
                    this.m_fileNETSaveButton.setEnabled(bIsCheckedOut);
                    this.m_fileNETSaveButton.setRolloverEnabled(bIsCheckedOut);
                }
                this.m_exportToFlattenedXPDLItem.setEnabled(true);
                this.m_transferPackageItem.setEnabled(true);
                this.m_launchMainProcessItem.setEnabled(true);
                this.m_launchMainProcessButton.setEnabled(true);
                this.m_launchMainProcessButton.setRolloverEnabled(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean performExitItemAction(boolean bCloseWindow) {
        boolean bExit = true;
        try {
            if (!this.m_bAppIsExiting) {
                this.m_designerCoreData.stopEditing();
                bExit = this.m_designerCoreData.isOkayToExit();
                if (bExit && bCloseWindow) {
                    Container parentContainer = this.m_designerCoreData.getSessionInfo().getParentContainer();
                    if (parentContainer != null && parentContainer instanceof JFrame) {
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)parentContainer, 201));
                    } else if (parentContainer != null && parentContainer instanceof VWBaseAppLauncherApplet) {
                        ((VWBaseAppLauncherApplet)parentContainer).closeWindow();
                    }
                    this.m_bAppIsExiting = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOpenPWMItemAction() {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.m_designerCoreData.getOpenItem().openPWM();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var3_2 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var3_1 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOpenProcessAdministratorItemAction() {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.m_designerCoreData.getOpenItem().openProcessAdministrator();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var3_2 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var3_1 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOpenSimulationConsoleItemAction() {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.m_designerCoreData.getOpenItem().openSimulationConsole();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var3_2 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var3_1 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    private void performModeSwitchAction() {
        VWWorkflowDefinition mainWflDef;
        boolean bEnableAdvancedItems = true;
        if (this.m_diagramModeItem.isSelected()) {
            bEnableAdvancedItems = false;
            this.m_designerCoreData.setApplicationMode(0);
            this.m_modeLabel.setText(VWResource.s_modeLabel.toString(VWResource.s_menuDiagramMode));
        } else {
            this.m_designerCoreData.setApplicationMode(1);
            this.m_modeLabel.setText(VWResource.s_modeLabel.toString(VWResource.s_menuDesignMode));
        }
        if (this.m_scenarioSeparator != null) {
            this.m_scenarioSeparator.setVisible(bEnableAdvancedItems);
        }
        if (this.m_newScenarioItem != null) {
            this.m_newScenarioItem.setVisible(bEnableAdvancedItems);
        }
        if (this.m_addLocalScenarioItem != null) {
            this.m_addLocalScenarioItem.setVisible(bEnableAdvancedItems);
        }
        if (this.m_addRepositoryScenarioItem != null) {
            this.m_addRepositoryScenarioItem.setVisible(bEnableAdvancedItems);
        }
        this.m_fileValidateMenuSeparator.setVisible(bEnableAdvancedItems);
        this.m_validatePackageItem.setVisible(bEnableAdvancedItems);
        this.m_transferPackageItem.setVisible(bEnableAdvancedItems);
        this.m_launchMainProcessItem.setVisible(bEnableAdvancedItems);
        if (this.m_scenarioCollectionMenuItem != null) {
            this.m_scenarioCollectionMenuItem.setVisible(bEnableAdvancedItems);
        }
        if (this.m_configurationItem != null) {
            this.m_configurationItem.setVisible(bEnableAdvancedItems);
        }
        if (this.m_rolesItem != null) {
            this.m_rolesItem.setVisible(bEnableAdvancedItems);
        }
        if (this.m_inbasketsItem != null) {
            this.m_inbasketsItem.setVisible(bEnableAdvancedItems);
        }
        this.m_toolsMenu.setVisible(bEnableAdvancedItems);
        this.m_validationToolbarSeparator.setVisible(bEnableAdvancedItems);
        this.m_validateProcessCollectionButton.setVisible(bEnableAdvancedItems);
        this.m_launchMainProcessButton.setVisible(bEnableAdvancedItems);
        this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 755, null);
        if (this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition() != null && (mainWflDef = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getMainWorkflow()) != null) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 716, mainWflDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPreferencesItemAction(int nDisplayType) {
        if (this.m_designerCoreData.getDesignerPreferences() != null) {
            VWDesignerPreferences designerPrefs = this.m_designerCoreData.getDesignerPreferences();
            boolean bOldDisplayInheritedItemsValue = designerPrefs.getShouldDisplayInheritedInformation();
            VWPreferencesDialog preferencesDlg = new VWPreferencesDialog(this.m_designerCoreData, nDisplayType);
            if (preferencesDlg != null) {
                preferencesDlg.reinitialize(designerPrefs);
                preferencesDlg.setVisible(true);
                if (preferencesDlg.getExitStatus() == 0) {
                    designerPrefs.savePreferencesSettings();
                    boolean bNewDisplayInheritedItemsValue = designerPrefs.getShouldDisplayInheritedInformation();
                    if (bOldDisplayInheritedItemsValue != bNewDisplayInheritedItemsValue) {
                        try {
                            try {
                                this.m_designerCoreData.displayWaitCursor();
                                this.m_designerCoreData.getTabbedCanvasPanel().showInheritedWorkflowInformation(bNewDisplayInheritedItemsValue);
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                Object var8_7 = null;
                                this.m_designerCoreData.restoreDefaultCursor();
                            }
                            Object var8_6 = null;
                            this.m_designerCoreData.restoreDefaultCursor();
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            this.m_designerCoreData.restoreDefaultCursor();
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    private void performAboutItemAction() {
        try {
            ImageIcon icon = VWImageLoader.createImageIcon("designer.gif");
            String productName = VWIDMBaseFactory.instance().getVWString(5).toString();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_designerCoreData.getParentFrame(), productName, icon, this.m_designerCoreData.getSessionInfo());
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performShowHideStepNames(boolean bShow) {
        this.m_designerCoreData.getMapAttributes().setStepNameVisible(bShow);
    }

    private void performShowHideRouteNames(boolean bShow) {
        this.m_designerCoreData.getMapAttributes().setRouteNameVisible(bShow);
    }

    private void performShowHideMilestoneAttrs(boolean bShow) {
        this.m_designerCoreData.getMapAttributes().setMilestoneVisible(bShow);
    }

    private void performShowHideConditionAttrs(boolean bShow) {
        this.m_designerCoreData.getMapAttributes().setConditionAttrsVisible(bShow);
    }

    private void performShowHideCollectorAttrs(boolean bShow) {
        this.m_designerCoreData.getMapAttributes().setCollectorAttrsVisible(bShow);
    }

    private void performShowHideTextAnnotations(boolean bShow) {
        this.m_designerCoreData.getMapAttributes().setTextAnnotationsVisible(bShow);
    }

    private void performDisplayOptionsChangedAction() {
        VWMapAttribs mapAttribs = this.m_designerCoreData.getMapAttributes();
        this.m_stepNamesCheckBox.setSelected(mapAttribs.isStepNameVisible());
        this.m_routeNamesCheckBox.setSelected(mapAttribs.isRouteNameVisible());
        this.m_milestoneAttrsCheckBox.setSelected(mapAttribs.isMilestoneVisible());
        this.m_conditionAttrsCheckBox.setSelected(mapAttribs.isConditionAttrsVisible());
        this.m_collectorAttrsCheckBox.setSelected(mapAttribs.isCollectorAttrsVisible());
        this.m_textAnnotationsCheckBox.setSelected(mapAttribs.isTextAnnotationsVisible());
        if (mapAttribs.isPageBoundaryVisible()) {
            this.m_designerCoreData.getTabbedCanvasPanel().getVWPrinter(null);
        }
    }

    private void releaseReferences() {
        if (this.m_toolsMenu != null) {
            Component[] items = this.m_toolsMenu.getMenuComponents();
            if (items != null) {
                for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_toolsMenu.removeAll();
            this.m_toolsMenu = null;
        }
        this.m_openPWMItem = null;
        this.m_openProcessAdministratorItem = null;
        this.m_openSimulationConsoleItem = null;
        if (this.m_designerCoreData != null) {
            this.m_designerCoreData.releaseReferences();
            this.m_designerCoreData = null;
        }
    }
}

